<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AmenityController extends Controller
{
    public function index()
    {
        $amenities = \App\Models\Amenity::latest()->get();
        return view('admin.amenities.index', compact('amenities'));
    }

    public function create()
    {
        return view('admin.amenities.create');
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'icon' => 'nullable|file|mimes:svg,png,jpg,jpeg|max:2048',
        ]);

        $data = $request->only('name');

        if ($request->hasFile('icon')) {
            $data['icon'] = $request->file('icon')->store('amenities', 'public');
        }

        \App\Models\Amenity::create($data);

        return redirect()->route('admin.amenities.index')->with('success', 'Amenity created successfully.');
    }

    public function destroy(\App\Models\Amenity $amenity)
    {
        $amenity->delete();
        return back()->with('success', 'Amenity deleted.');
    }
}
